/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingCondition;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.util.KeyNotFoundException;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import dev.gigaherz.jsonthings.util.parse.value.ArrayValue;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ThingParser<TBuilder extends BaseBuilder<?, TBuilder>>
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, ThingCondition> CONDITIONS_REGISTRY = new HashMap<ResourceLocation, ThingCondition>();
    protected static Gson GSON;
    private final Map<ResourceLocation, @NotNull TBuilder> buildersByName = Maps.newHashMap();
    private final List<TBuilder> builders = Lists.newArrayList();
    private final String thingType;
    private final Gson gson;
    private static final Map<String, Rarity> rarities;
    private static final Set<String> VALID_BLOCK_LAYERS;

    public static synchronized void registerCondition(ResourceLocation id, ThingCondition condition) {
        CONDITIONS_REGISTRY.put(id, condition);
    }

    public static boolean parseAndTestConditions(String thingType, ResourceLocation thingId, JsonElement json) {
        JsonElement conditions = json.getAsJsonObject().get("conditions");
        if (conditions == null) {
            return true;
        }
        JsonArray conditionArray = conditions.getAsJsonArray();
        for (JsonElement e : conditionArray) {
            if (ThingParser.parseAndTestCondition(thingType, thingId, e.getAsJsonObject())) continue;
            return false;
        }
        return true;
    }

    public static boolean parseAndTestCondition(String thingType, ResourceLocation thingId, JsonObject condition) {
        ResourceLocation type = new ResourceLocation(condition.get("type").getAsString());
        ThingCondition conditionHandler = CONDITIONS_REGISTRY.get(type);
        if (conditionHandler == null) {
            throw new JsonParseException("Unknown condition type for id '" + type + "' while parsing " + thingId);
        }
        return conditionHandler.test(thingType, thingId, condition);
    }

    public static <T> void processAndConsumeErrors(String thingType, Iterable<T> list, Consumer<T> consumer, Function<T, ResourceLocation> keyGetter) {
        list.forEach(thing -> ThingParser.processAndConsumeErrors(thingType, () -> consumer.accept(thing), () -> (ResourceLocation)keyGetter.apply(thing)));
    }

    public static <K, V> void processAndConsumeErrors(String thingType, Map<K, V> list, BiConsumer<K, V> consumer, Function<K, ResourceLocation> keyGetter) {
        list.forEach((key, value) -> ThingParser.processAndConsumeErrors(thingType, () -> consumer.accept(key, value), () -> (ResourceLocation)keyGetter.apply(key)));
    }

    public static void processAndConsumeErrors(String thingType, Runnable r, Supplier<ResourceLocation> keyGetter) {
        try {
            r.run();
        }
        catch (JsonParseException | ThingParseException | KeyNotFoundException | IllegalStateException e) {
            ThingParser.processParseException(thingType, keyGetter.get(), e);
        }
    }

    public static void processParseException(String thingType, ResourceLocation key, Throwable e) {
        String message = "Error parsing " + thingType + " with id '" + key + "': " + e.getMessage();
        LOGGER.error(message);
        LOGGER.debug("Details for message above", e);
        Optional modContainer = ModList.get().getModContainerById(key.m_135827_());
        if (modContainer.isEmpty()) {
            modContainer = ModList.get().getModContainerById("jsonthings");
        }
        ModLoader.get().addWarning(new ModLoadingWarning(((ModContainer)modContainer.orElseThrow()).getModInfo(), ModLoadingStage.ERROR, "Json Things: " + message, new Object[0]));
    }

    public ThingParser(Gson gson, String thingType) {
        super(gson, thingType);
        this.gson = gson;
        this.thingType = thingType;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManager, ProfilerFiller profilerIn) {
        ThingParser.processAndConsumeErrors(this.thingType, objectIn, (K key, V json) -> {
            TBuilder builder = this.parseFromElement((ResourceLocation)key, (JsonElement)json);
            if (builder != null) {
                this.buildersByName.put((ResourceLocation)key, builder);
            }
        }, Function.identity());
    }

    protected abstract TBuilder processThing(ResourceLocation var1, JsonObject var2, Consumer<TBuilder> var3);

    @Nullable
    public TBuilder parseFromElement(ResourceLocation key, JsonElement json) {
        return (TBuilder)this.parseFromElement(key, json, b -> {});
    }

    @Nullable
    public TBuilder parseFromElement(ResourceLocation thingId, JsonElement json, Consumer<TBuilder> builderModification) {
        if (!ThingParser.parseAndTestConditions(this.thingType, thingId, json)) {
            return null;
        }
        TBuilder builder = this.processThing(thingId, json.getAsJsonObject(), builderModification);
        this.builders.add(builder);
        return builder;
    }

    public List<TBuilder> getBuilders() {
        return Collections.unmodifiableList(this.builders);
    }

    public Map<ResourceLocation, TBuilder> getBuildersMap() {
        return Collections.unmodifiableMap(this.buildersByName);
    }

    protected StackContext parseStackContext(JsonObject item, boolean allowItem, boolean requireItem) {
        ResourceLocation itemName = null;
        if (item.has("item")) {
            if (!allowItem) {
                throw new JsonParseException("'item' key provided in a context that doesn't allow customizing the item.");
            }
            itemName = new ResourceLocation(item.get("item").getAsString());
        } else if (requireItem) {
            throw new JsonParseException("'item' key missing in a context that requires the item.");
        }
        StackContext ctx = new StackContext(itemName);
        if (item.has("count")) {
            int meta = item.get("count").getAsInt();
            ctx = ctx.withCount(meta);
        }
        if (item.has("nbt")) {
            try {
                JsonElement element = item.get("nbt");
                CompoundTag nbt = element.isJsonObject() ? TagParser.m_129359_((String)this.gson.toJson(element)) : TagParser.m_129359_((String)element.getAsString());
                ctx = ctx.withTag(nbt);
            }
            catch (Exception e) {
                throw new ThingParseException("Failed to parse NBT json.", e);
            }
        }
        return ctx;
    }

    protected Map<String, List<ResourceLocation>> parseEvents(ObjValue objValue) {
        HashMap<String, List<ResourceLocation>> map = new HashMap<String, List<ResourceLocation>>();
        objValue.forEach((str, any) -> any.ifString(val -> map.put((String)str, List.of(new ResourceLocation(val.getAsString())))).ifArray(arr -> map.put((String)str, arr.flatMap(f -> f.map(val -> new ResourceLocation(val.string().getAsString())).toList()))).typeError());
        return map;
    }

    protected static Rarity parseRarity(String str) {
        Rarity rarity = rarities.get(str);
        if (rarity == null) {
            throw new ThingParseException("No item rarity known with name " + str);
        }
        return rarity;
    }

    public final void finishLoading() {
        this.finishLoadingInternal();
    }

    protected void finishLoadingInternal() {
    }

    public String getThingType() {
        return this.thingType;
    }

    public TBuilder getOrCrash(ResourceLocation name) {
        BaseBuilder b = (BaseBuilder)this.buildersByName.get(name);
        if (b == null) {
            throw new ThingParseException("There is no known " + this.thingType + " with name " + name);
        }
        return (TBuilder)b;
    }

    public static int parseColor(String color) {
        if (color.startsWith("#")) {
            if ((color = color.toUpperCase(Locale.ROOT).substring(1)).length() == 8) {
                return (int)Long.parseLong(color, 16);
            }
            if (color.length() == 6) {
                return 0xFF000000 | Integer.parseInt(color, 16);
            }
            throw new ThingParseException("Color hex string must be either 6 or 8 digits long.");
        }
        return (int)Long.parseLong(color);
    }

    public static int parseColor(ObjValue color) {
        int[] values = new int[4];
        values[0] = 255;
        color.ifKey("a", any -> any.intValue().handle(i -> {
            values[0] = i;
        })).ifKey("r", any -> any.intValue().handle(i -> {
            values[1] = i;
        })).ifKey("g", any -> any.intValue().handle(i -> {
            values[2] = i;
        })).ifKey("b", any -> any.intValue().handle(i -> {
            values[3] = i;
        }));
        return values[0] << 24 | values[1] << 16 | values[2] << 8 | values[3];
    }

    public static int parseColor(ArrayValue color) {
        int[] values = new int[4];
        color.between(3, 4).raw(arr -> {
            int i = 0;
            values[0] = arr.size() == 4 ? arr.get(i++).getAsInt() : 255;
            values[1] = arr.get(i++).getAsInt();
            values[2] = arr.get(i++).getAsInt();
            values[3] = arr.get(i).getAsInt();
        });
        return values[0] << 24 | values[1] << 16 | values[2] << 8 | values[3];
    }

    public static Set<String> parseRenderLayers(Any data) {
        HashSet types = Sets.newHashSet();
        data.ifString(str -> str.handle(name -> types.add(ThingParser.verifyRenderLayer(name)))).ifArray(arr -> arr.forEach((i, val) -> types.add(ThingParser.verifyRenderLayer(val.string().getAsString())))).typeError();
        return types;
    }

    private static String verifyRenderLayer(String layerName) {
        if (!VALID_BLOCK_LAYERS.contains(layerName)) {
            throw new ThingParseException("Render layer " + layerName + " is not a valid block chunk layer.");
        }
        return layerName;
    }

    static {
        ThingParser.registerCondition(new ResourceLocation("mod_loaded"), (type, id, data) -> ModList.get().isLoaded(data.get("modid").getAsString()));
        ThingParser.registerCondition(new ResourceLocation("not"), (type, id, data) -> !ThingParser.parseAndTestCondition(type, id, data.get("condition").getAsJsonObject()));
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        rarities = ImmutableMap.builder().put((Object)"common", (Object)Rarity.COMMON).put((Object)"uncommon", (Object)Rarity.UNCOMMON).put((Object)"rare", (Object)Rarity.RARE).put((Object)"epic", (Object)Rarity.EPIC).build();
        VALID_BLOCK_LAYERS = Sets.newHashSet((Object[])new String[]{"solid", "cutout_mipped", "cutout", "translucent", "tripwire"});
    }
}

